package cn.com.duiba.quanyi.center.api.remoteservice.mall.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.page.MallPageRegionDto;
import cn.com.duiba.quanyi.center.api.param.mall.page.MallPageRegionSearchParam;
import java.util.List;

/**
 * 商城页面区域
 * @author kjj mybatis generator 
 * @date 2024-05-23
 */
@AdvancedFeignClient
public interface RemoteMallPageRegionService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商城页面区域集合
     */
    List<MallPageRegionDto> selectPage(MallPageRegionSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MallPageRegionSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城页面区域
     */
    MallPageRegionDto selectById(Long id);

    /**
     * 新增
     * @param dto 商城页面区域
     * @return 执行结果
     */
    int insert(MallPageRegionDto dto);

    /**
     * 更新
     * @param dto 商城页面区域
     * @return 影响行数
     */
    int update(MallPageRegionDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}