package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.ActivityDemandAbnormalCountDto;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.ConsumeStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.ConsumeStatisticSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 运营工作台-消耗数据统计表
 * @author kjj mybatis generator
 * @date 2025-06-05
 */
@AdvancedFeignClient
public interface RemoteConsumeStatisticService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 运营工作台-消耗数据统计集合
     */
    List<ConsumeStatisticDto> selectPage(ConsumeStatisticSearchParam param);

    /**
     * 根据条件查询，管理后端列表查询专用-不分页
     * @param param 查询条件
     * @return 运营工作台-消耗数据统计集合
     */
    List<ConsumeStatisticDto> selectNoPage(ConsumeStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ConsumeStatisticSearchParam param);

    /**
     * 获取活动和需求异常数
     * @param createOperatorId 创建人id
     * @param statDate 统计时间
     * @return 获取活动和需求异常数
     */
    ActivityDemandAbnormalCountDto getActivityAndDemandAbnormalCount(Long createOperatorId, Date statDate);

    /**
     * 根据ID查询
     * @param id 主键id
     * @return 运营工作台-消耗数据统计
     */
    ConsumeStatisticDto selectById(Long id);

    /**
     * 处理运营工作台-消耗数据统计
     * @param id 主键id
     * @return 处理结果
     */
    int processConsumeStatistic(Long id);
}
