package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentSubjectRefDto;
import cn.com.duiba.quanyi.center.api.param.settlement.receive.ReceivedPaymentSubjectRefSearchParam;
import java.util.List;

/**
 * 回款主体与发票主体关联关系
 * @author kjj mybatis generator 
 * @date 2025-05-26
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentSubjectRefService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 回款主体与发票主体关联关系集合
     */
    List<ReceivedPaymentSubjectRefDto> selectPage(ReceivedPaymentSubjectRefSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ReceivedPaymentSubjectRefSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款主体与发票主体关联关系
     */
    ReceivedPaymentSubjectRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 回款主体与发票主体关联关系
     * @return 执行结果
     */
    int insert(ReceivedPaymentSubjectRefDto dto);

    /**
     * 更新
     * @param dto 回款主体与发票主体关联关系
     * @return 影响行数
     */
    int update(ReceivedPaymentSubjectRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 通过回款id和发票抬头查询
     * @param subjectId 回款id
     * @param invoiceTitle 发票抬头
     * @return
     */
    ReceivedPaymentSubjectRefDto selectBySubjectIdAndTitle(Long subjectId, String invoiceTitle);

    /**
     * 通过回款主体ids查询
     * @param subjectIds 回款主体ids
     * @return
     */
    List<ReceivedPaymentSubjectRefDto> selectByReceivedSubjectIds(List<Long> subjectIds);

    /**
     * 批量保存或更新
     * @param list
     * @return
     */
    boolean batchSaveOrUpdate(List<ReceivedPaymentSubjectRefDto> list);
}