/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.log.operate.log;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.quanyi.center.api.dto.common.OperateLogDetailDto;
import cn.com.duiba.quanyi.center.api.log.operate.LogAopUtil;
import cn.com.duiba.quanyi.center.api.log.operate.annotation.OperateLogMethod;
import cn.com.duiba.quanyi.center.api.log.operate.log.OperateLogger;
import cn.com.duiba.quanyi.center.api.remoteservice.RemoteOperateLogService;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OperateLogAop {
    private static final Logger log = LoggerFactory.getLogger(OperateLogAop.class);
    @Resource
    private RemoteOperateLogService operateLogService;

    @Pointcut(value="@annotation(cn.com.duiba.quanyi.center.api.log.operate.annotation.OperateLogMethod)")
    public void logger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="logger()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        Object result = null;
        try {
            OperateLogMethod annotation = this.getAnnotation(joinPoint);
            if (annotation != null) {
                OperateLogger.init();
            }
            Object object = result = joinPoint.proceed();
            return object;
        }
        catch (Exception ex) {
            result = ex.getMessage();
            throw ex;
        }
        finally {
            try {
                this.operateLog(request, joinPoint, result);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            finally {
                OperateLogger.clearThreadLocal();
            }
        }
    }

    private OperateLogMethod getAnnotation(ProceedingJoinPoint joinPoint) {
        if (joinPoint == null) {
            return null;
        }
        Method method = LogAopUtil.getMethod(joinPoint);
        if (method == null) {
            return null;
        }
        return method.getAnnotation(OperateLogMethod.class);
    }

    private void operateLog(HttpServletRequest request, ProceedingJoinPoint joinPoint, Object result) throws BizException {
        OperateLogMethod annotation = this.getAnnotation(joinPoint);
        if (annotation == null) {
            return;
        }
        String path = LogAopUtil.getPath(request);
        if (Objects.isNull(OperateLogger.getOperateLoggerStackContext().getOperatorId())) {
            throw new BizException("\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a, path=" + path);
        }
        OperateLogDetailDto dto = new OperateLogDetailDto();
        dto.setGroupName(annotation.group());
        dto.setOperateTypeName(annotation.type());
        this.fillOperatorData(dto);
        dto.setOperatePath(path);
        dto.setParamInfo(LogAopUtil.getRequestBody(joinPoint, 10000, 1000));
        dto.setResultInfo(LogAopUtil.getResponseBody(result, 10000, 1000));
        this.operateLogService.insert(dto);
    }

    private void fillOperatorData(OperateLogDetailDto dto) {
        try {
            dto.setOperatorId(OperateLogger.getOperateLoggerStackContext().getOperatorId());
            dto.setOperatorName(OperateLogger.getOperateLoggerStackContext().getOperatorName());
            dto.setBizId(OperateLogger.getOperateLoggerStackContext().getBizId());
        }
        catch (Exception e) {
            log.warn("[\u64cd\u4f5c\u65e5\u5fd7], \u83b7\u53d6\u4e1a\u52a1Id\u65f6\u53d1\u751f\u5f02\u5e38, ", (Throwable)e);
        }
    }
}

