/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon;

import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public enum MeiTuanCouponTypeEnum {
    DISCOUNT_COUPON(1, "\u7acb\u51cf\u5238"),
    FULL_REDUCTION_COUPON(3, "\u6ee1\u51cf\u5238"),
    PERCENTAGE_DISCOUNT_COUPON(4, "\u6298\u6263\u5238"),
    FIXED_PRICE_COUPON(7, "\u4e00\u53e3\u4ef7\u5238");

    private int code;
    private String description;

    public static MeiTuanCouponTypeEnum getByCode(int code) {
        for (MeiTuanCouponTypeEnum status : MeiTuanCouponTypeEnum.values()) {
            if (status.code != code) continue;
            return status;
        }
        return null;
    }

    public static Integer isAmountType(int code) {
        if (DISCOUNT_COUPON.getCode() == code || FULL_REDUCTION_COUPON.getCode() == code) {
            return AmountTypeEnum.FIXED.getType();
        }
        if (PERCENTAGE_DISCOUNT_COUPON.getCode() == code || FIXED_PRICE_COUPON.getCode() == code) {
            return AmountTypeEnum.UNFIXED.getType();
        }
        return null;
    }

    public static Pair<Long, Long> isMinAmountAndMaxAmount(Integer couponType, Long quotaValue, Long reduceValue, Long discountValue, Long fixedPriceValue) {
        if (Objects.isNull(couponType)) {
            return Pair.of((Object)0L, (Object)0L);
        }
        MeiTuanCouponTypeEnum byCode = MeiTuanCouponTypeEnum.getByCode(couponType);
        if (Objects.isNull((Object)byCode)) {
            return Pair.of((Object)0L, (Object)0L);
        }
        switch (byCode) {
            case PERCENTAGE_DISCOUNT_COUPON: {
                Long discountAmount = MeiTuanCouponTypeEnum.getDiscountAmount(quotaValue, discountValue);
                return Pair.of((Object)discountAmount, (Object)reduceValue);
            }
            case FIXED_PRICE_COUPON: {
                Long buyItNowAmount = MeiTuanCouponTypeEnum.getBuyItNowAmount(quotaValue, fixedPriceValue);
                return Pair.of((Object)buyItNowAmount, (Object)reduceValue);
            }
        }
        return Pair.of((Object)0L, (Object)0L);
    }

    private static Long getDiscountAmount(Long quotaValue, Long discountValue) {
        if (quotaValue == null || quotaValue <= 0L || discountValue == null || discountValue <= 0L) {
            throw new IllegalArgumentException("Invalid parameters: quotaValue and discountValue must be positive.");
        }
        BigDecimal amount = new BigDecimal(quotaValue);
        BigDecimal rate = new BigDecimal(discountValue);
        BigDecimal discount = amount.multiply(rate).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return amount.subtract(discount).longValue();
    }

    private static Long getBuyItNowAmount(Long quotaValue, Long fixedPriceValue) {
        if (quotaValue == null || fixedPriceValue == null) {
            throw new IllegalArgumentException("quotaValue and fixedPriceValue cannot be null");
        }
        if (quotaValue < 0L || fixedPriceValue < 0L) {
            throw new IllegalArgumentException("quotaValue and fixedPriceValue must be non-negative");
        }
        BigDecimal amount = new BigDecimal(quotaValue);
        BigDecimal reduce = new BigDecimal(fixedPriceValue);
        return amount.subtract(reduce).longValue();
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private MeiTuanCouponTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }
}

