package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author zzy
 * @create 2025/07/02 12:44
 **/
@Data
public class WxQueryBankMultiActivityCouponDetailDto implements Serializable {
    private static final long serialVersionUID = -2147608494773751550L;
    /**
     * coupon_id 　必填 string
     * <p>
     * 【代金券ID】 微信为代金券唯一分配的ID
     */
    private String couponId;

    /**
     * coupon_name 　必填 string
     * <p>
     * 【券名称】 券名称
     */
    private String couponName;

    /**
     * coupon_state 　必填 string
     * 【券状态】 券状态
     * 可选取值:
     * COUPON_STATE_UNKNOW: 未知状态
     * COUPON_STATE_SEND: 可用
     * COUPON_STATE_USED: 已实扣
     * COUPON_STATE_EXPIRED: 已过期
     */
    private String couponState;

    /**
     * receive_time 　必填 string
     * <p>
     * 【领券时间】 领券时间
     */
    private Date receiveTime;

    /**
     * available_begin_time 　必填 string
     * <p>
     * 【可用开始时间】 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * available_end_time 　必填 string
     * <p>
     * 【可用结束时间】 可用结束时间
     */
    private Date availableEndTime;

    /**
     * max_use_number 　必填 integer
     * <p>
     * 【最大使用次数】 券的最大使用次数
     */
    private Integer maxUseNumber;

    /**
     * available_number 　必填 integer
     * <p>
     * 【可用次数】 券的剩余可用次数
     */
    private Integer availableNumber;

    /**
     * used_number 　必填 integer
     * <p>
     * 【已使用次数】 券的已使用次数
     */
    private Integer usedNumber;

    /**
     * use_amount_list 　选填 object
     * <p>
     * 【已用金额列表】 券的已使用金额列表，列表中的元素代表该次使用的金额
     */
    private UseAmountList useAmountList;

    /**
     * 是否成功
     */
    private Boolean success;

    /**
     * 错误码
     */
    private String errorCode = "000000";

    /**
     * 失败原因
     */
    private String errorMsg;


    @Data
    public static class UseAmountList implements Serializable {
        private static final long serialVersionUID = -3148142613743983579L;
        /**
         * used_amounts 　选填 array[string]
         * <p>
         * 【已用金额】 券的本次使用金额，单位：分。
         */
        private List<Long> usedAmounts = Collections.emptyList();
    }
}
