package cn.com.duiba.quanyi.center.api.dto.task;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 定时任务表
 * @author mybatis generator
 * @date 2025-06-11
 */
@Data
public class ScheduledTaskDto implements Serializable {

    private static final long serialVersionUID = 17496211769811853L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否循环，0-不是，1-是
     */
    private Integer cycleStatus;

    /**
     * 循环类型，1-每天，2-每周，3-每月
     * @see cn.com.duiba.quanyi.center.api.enums.task.ScheduledTaskCycleTypeEnum
     */
    private Integer cycleType;

    /**
     * 开始时间（yyyy-MM-dd）
     */
    private Long taskStartTime;

    /**
     * 结束时间（yyyy-MM-dd）
     */
    private Long taskEndTime;

    /**
     * 执行时分秒
     */
    private Integer taskSecondTime;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 业务ID扩展
     */
    private Long bizExtId;

    /**
     * 业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.task.ScheduledTaskBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务规则，1-替换，2-新增，3-删除，等等
     * @see cn.com.duiba.quanyi.center.api.enums.task.ScheduledTaskBizRuleEnum
     */
    private Integer bizRule;

    /**
     * 业务数据
     * @see cn.com.duiba.quanyi.center.api.dto.task.ScheduledTaskBizDataDto
     */
    private String bizData;

    /**
     * 业务扩展信息
     * @see cn.com.duiba.quanyi.center.api.dto.task.ScheduledTaskBizExtInfoDto
     */
    private String bizExtInfo;

    /**
     * 是否启用, 0-停用, 1-启用
     */
    private Integer bizStatus;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;
}
