package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 微信银行编码
 * @author lizhi
 * @date 2023/8/7 17:45
 */
@Getter
@AllArgsConstructor
public enum BankEnum {
    /**
     * 微信银行编码
     */
    ICBC("工商银行"),
    JLB("吉林银行"),
    JLNX("吉林农信"),
    ABC("农业银行"),
    JNRCB("江南农商行"),
    PSBC("邮储银行"),
    JRCB("江阴农商行"),
    CCB("建设银行"),
    JSB("江苏银行"),
    CMB("招商银行"),
    JSHB("晋商银行"),
    BOC("中国银行"),
    JSNX("江苏农信"),
    COMM("交通银行"),
    JUFENGB("临朐聚丰村镇银行"),
    JXB("西昌金信村镇银行"),
    SPDB("浦发银行"),
    JXNXB("江西农信"),
    JZB("晋中银行"),
    GDB("广发银行"),
    JZCB("锦州银行"),
    CMBC("民生银行"),
    KCBEB("天津金城银行"),
    PAB("平安银行"),
    KLB("昆仑银行"),
    CEB("光大银行"),
    KRCB("昆山农商"),
    KSHB("梅州客商银行"),
    CIB("兴业银行"),
    KUERLECB("库尔勒市商业银行"),
    LCYRB("陵城圆融村镇银行"),
    CITIC("中信银行"),
    LICYRB("历城圆融村镇银行"),
    LJB("龙江银行"),
    BOSH("上海银行"),
    LLB("山东兰陵村镇银行"),
    LLHZCB("柳林汇泽村镇银行"),
    AHRCUB("安徽省农村信用社联合社"),
    LNNX("辽宁农信"),
    LPCB("凉山州商业银行"),
    AIB("百信银行"),
    LPSBLVB("钟山凉都村镇银行"),
    ASCB("鞍山银行"),
    LSB("临商银行"),
    ATRB("盘山安泰村镇银行"),
    BCZ("沧州银行"),
    LSCCB("乐山市商业银行"),
    LUZB("柳州银行"),
    BDB("保定银行"),
    LWB("莱商银行"),
    BEEB("鄞州银行"),
    LYYHB("辽阳银行"),
    LZB("兰州银行"),
    BGZB("贵州银行"),
    BHB("河北银行"),
    LZCCB("泸州市商业银行"),
    MHBRB("闵行上银村镇银行"),
    BJRCB("北京农商行"),
    MINTAIB("民泰银行"),
    BNC("江西银行"),
    MPJDRB("牟平胶东村镇银行"),
    MYCCB("绵阳市商业银行"),
    BOB("北京银行"),
    NBCB("宁波银行"),
    BOBBG("北部湾银行"),
    NCB("宁波通商银行"),
    NCBCB("南洋商业银行"),
    BOCD("成都银行"),
    NCCB("四川天府银行"),
    BOCDB("承德银行"),
    NJCB("南京银行"),
    BOCFB("中银富登村镇银行"),
    BOCTS("焦作中旅银行"),
    NJJDRB("宁津胶东村镇银行"),
    BOD("东莞银行"),
    NJXLRB("内江兴隆村镇银行"),
    NMGNX("内蒙古农信"),
    BOFS("抚顺银行"),
    NNGMB("南宁江南国民村镇银行"),
    BOHN("海南银行"),
    NUB("辽宁振兴银行"),
    BOIMCB("内蒙古银行"),
    NYCCB("南阳村镇银行"),
    OCBCWHCB("华侨永亨银行"),
    BOJN("济宁银行"),
    OHVB("鄂托克旗汇泽村镇银行"),
    BOJX("嘉兴银行"),
    ORDOSB("鄂尔多斯银行"),
    BOLB("洛阳银行"),
    BOLFB("廊坊银行"),
    PBDLRB("平坝鼎立村镇银行"),
    BONX("宁夏银行"),
    PJDWHFB("大洼恒丰村镇银行"),
    PJJYRB("浦江嘉银村镇银行"),
    BOPDS("平顶山银行"),
    PZHCCB("攀枝花银行"),
    BOPJ("盘锦银行"),
    QDCCB("青岛银行"),
    BOQHB("青海银行"),
    QHDB("秦皇岛银行"),
    BOSXB("绍兴银行"),
    QHJDRB("齐河胶东村镇银行"),
    BOSZS("石嘴山银行"),
    QHNX("青海农信"),
    BOTSB("唐山银行"),
    QJSYB("衢江上银村镇银行"),
    BOZ("张家口银行"),
    QLB("齐鲁银行"),
    BSB("包商银行"),
    QLVB("青隆村镇银行"),
    QSB("齐商银行"),
    BYK("营口银行"),
    CBHB("渤海银行"),
    QZCCB("泉州银行"),
    CCAB("长安银行"),
    RHCB("长子县融汇村镇银行"),
    CDRCB("成都农商银行"),
    RQCZB("任丘村镇银行"),
    CITIB("花旗银行"),
    RXYHB("瑞信村镇银行"),
    RZB("日照银行"),
    CJCCB("江苏长江商业银行"),
    SCB("渣打银行"),
    CQB("重庆银行"),
    SCNX("四川农信"),
    CQRCB("重庆农村商业银行"),
    SDEB("顺德农商行"),
    CQTGB("重庆三峡银行"),
    SDRCU("山东农信"),
    CRB("珠海华润银行"),
    SHHJB("商河汇金村镇银行"),
    SHINHAN("新韩银行"),
    CSCB("长沙银行"),
    SHRB("上海华瑞银行"),
    SJB("盛京银行"),
    CSRCB("常熟农商银行"),
    SNB("苏宁银行"),
    CSXB("三湘银行"),
    SNCCB("遂宁银行"),
    CYCB("朝阳银行"),
    SPDYB("四平铁西敦银村镇银行"),
    SRB("上饶银行"),
    CZB("浙商银行"),
    SRCB("上海农商银行"),
    CZCB("稠州银行"),
    SUZB("苏州银行"),
    CZCCB("长治银行"),
    SXNX("山西农信"),
    DANDONGB("丹东银行"),
    SXXH("陕西信合"),
    SZRCB("深圳农商银行"),
    DBSB("星展银行"),
    DCSFRB("大城舜丰村镇银行"),
    TACCB("泰安银行"),
    DHDYB("德惠敦银村镇银行"),
    DHRB("调兵山惠民村镇银行"),
    TCRCB("太仓农商行"),
    DLB("大连银行"),
    TJB("天津银行"),
    DLRCB("大连农商行"),
    TJBHB("天津滨海农商行"),
    DRCB("东莞农商银行"),
    TJHMB("天津华明村镇银行"),
    DSB("大新银行"),
    TJNHVB("天津宁河村镇银行"),
    DTCCB("大同银行"),
    TLB("铁岭银行"),
    DYB("东营银行"),
    TLVB("铁岭新星村镇银行"),
    TMDYB("图们敦银村镇银行"),
    DYCCB("长城华西银行"),
    TRCB("天津农商"),
    DYLSB("东营莱商村镇银行"),
    DZB("德州银行"),
    TZB("台州银行"),
    DZCCB("达州银行"),
    EDRB("鼎业村镇银行"),
    UOB("大华银行"),
    ESUNB("玉山银行"),
    URB("联合村镇银行"),
    FBB("富邦华一银行"),
    VBCB("村镇银行"),
    FDB("富滇银行"),
    WACZB("武安村镇银行"),
    WB("友利银行"),
    FJHXB("福建海峡银行"),
    WEB("微众银行"),
    WEGOB("蓝海银行"),
    FJNX("福建农信银行"),
    WFB("潍坊银行"),
    FUXINB("阜新银行"),
    WHB("威海商业银行"),
    FXLZB("费县梁邹村镇银行"),
    WHRC("武汉农商行"),
    GADRB("贵安新区发展村镇银行"),
    GDHX("广东华兴银行"),
    WHRYVB("芜湖圆融村镇银行"),
    GDNYB("南粤银行"),
    WJRCB("吴江农商行"),
    GDRCU("广东农信银行"),
    WLMQB("乌鲁木齐银行"),
    GLB("桂林银行"),
    WRCB("无锡农商行"),
    GLGMCB("桂林国民村镇银行"),
    GRCB("广州农商银行"),
    WUHAICB("乌海银行"),
    WZB("温州银行"),
    GSB("甘肃银行"),
    GSNX("甘肃农信"),
    WZMSB("温州民商"),
    GSRB("广阳舜丰村镇银行"),
    XAB("西安银行"),
    GXNX("广西农信"),
    XCXPB("许昌新浦村镇银行"),
    GYCB("贵阳银行"),
    XHB("大连鑫汇村镇银行"),
    XHNMB("安顺西航南马村镇银行"),
    GZCB("广州银行"),
    XIB("厦门国际银行"),
    XINANB("安徽新安银行"),
    GZCCB("赣州银行"),
    XJB("新疆银行"),
    XJJDRB("夏津胶东村镇银行"),
    GZNX("贵州农信"),
    XJRCCB("新疆农信银行"),
    HAINNX("海南农信"),
    XMCCB("厦门银行"),
    HANAB("韩亚银行"),
    XRTB("元氏信融村镇银行"),
    HBCB("湖北银行"),
    XTB("邢台银行"),
    HBNX("湖北农信"),
    XWB("新网银行"),
    XXCB("新乡银行"),
    HDCB("邯郸银行"),
    XXHZCB("兴县汇泽村镇银行"),
    HEBNX("河北农信"),
    XXRB("新乡新兴村镇银行"),
    HFB("恒丰银行"),
    XYPQZYCB("信阳平桥中原村镇银行"),
    XZB("西藏银行"),
    HKB("汉口银行"),
    YACCB("雅安市商业银行"),
    YBCCB("宜宾商业银行"),
    HKBEA("东亚银行"),
    YKCB("营口沿海银行"),
    YLB("亿联银行"),
    HKUB("海口联合农商银行"),
    YNHTB("云南红塔银行"),
    HLDCCB("葫芦岛银行"),
    HLDYB("和龙敦银村镇银行"),
    YNRCCB("云南农信"),
    HLJRCUB("黑龙江农信社"),
    HMCCB("哈密银行"),
    YQCCB("阳泉市商业银行"),
    HNNX("河南农信"),
    YQMYRB("玉泉蒙银村镇银行"),
    HRBB("哈尔滨银行"),
    YRRCB("黄河农商银行"),
    HRCB("保德慧融村镇银行"),
    YTB("烟台银行"),
    HRXJB("华融湘江银行"),
    YYBSCB("沂源博商村镇银行"),
    ZCRB("遵义新蒲长征村镇银行"),
    HSB("徽商银行"),
    ZGB("自贡银行"),
    ZGCB("北京中关村银行"),
    HSBC("恒生银行"),
    ZHCB("庄河汇通村镇银行"),
    HSBCC("汇丰银行"),
    ZHQYTB("沾化青云村镇银行"),
    ZJB("紫金农商银行"),
    HSCB("衡水银行"),
    ZJLXRB("兰溪越商银行"),
    HUIHEB("新疆汇和银行"),
    ZJRCUB("浙江农信"),
    HUNNX("湖南农信"),
    HUSRB("湖商村镇银行"),
    ZJTLCB("浙江泰隆银行"),
    HXB("华夏银行"),
    ZRCB("张家港农商行"),
    HZB("杭州银行"),
    ZSXKCCB("中山小榄村镇银行"),
    HZCCB("湖州银行"),
    ZYB("中原银行"),
    IBKB("企业银行"),
    JCB("晋城银行"),
    ZZB("郑州银行"),
    JCBK("晋城银行"),
    JDHDB("上海嘉定洪都村镇银行"),
    ZZCCB("枣庄银行"),
    JDZCCB("景德镇市商业银行"),
    DINERSCLUD("DINERSCLUD"),
    JHCCB("金华银行"),
    MASTERCARD("MASTERCARD"),
    VISA("VISA"),
    JJCCB("九江银行"),
    AMERICANEXPRESS("AMERICANEXPRESS"),
    DISCOVER("DISCOVER"),
    UPQUICKPASS("云闪付"),
    OTHERS("其他（银行卡以外）"),
            ;

    /**
     * 银行名称
     */
    private final String bankName;
    
    private static final Map<String, String> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BankEnum::name, BankEnum::getBankName, (v1, v2) -> v2)));
    
    /**
     * 根据银行编码获取银行名称
     * @param bankType 银行编码
     * @return 银行名称
     */
    public static String getNameByType(String bankType) {
        if (bankType == null) {
            return null;
        }
        return ENUM_MAP.get(bankType);
    }
}
