package cn.com.duiba.quanyi.center.api.enums.project;

import cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 项目所属业务类型
 * @date 2024/10/22
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum BelongingBusinessTypeEnum {
    BANK_CHANNEL_BUSINESS(1, "银行渠道", BusinessGroupTypeEnum.RIGHTS),
    INSURANCE_BUSINESS(2, "保险业务", BusinessGroupTypeEnum.RIGHTS),
    INNOVATION_BUSINESS(3, "创新业务", BusinessGroupTypeEnum.RIGHTS),
    DIGITAL_MARKETING(4, "数字营销", BusinessGroupTypeEnum.DIGITAL),
    ;

    private final Integer type;
    private final String desc;
    private final BusinessGroupTypeEnum businessGroup;

    private static final Map<String, BelongingBusinessTypeEnum> DESC_ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BelongingBusinessTypeEnum::getDesc, Function.identity(), (v1, v2) -> v2)));


    public static BelongingBusinessTypeEnum getEnumByDesc(String desc) {
        return DESC_ENUM_MAP.get(desc);
    }
    public static BelongingBusinessTypeEnum getEnum(Integer type) {
        for (BelongingBusinessTypeEnum enumItem : BelongingBusinessTypeEnum.values()) {
            if (enumItem.getType().equals(type)) {
                return enumItem;
            }
        }
        return null;
    }

    public static String getDescByType(Integer type) {
        BelongingBusinessTypeEnum enumItem = getEnum(type);
        if (enumItem != null) {
            return enumItem.getDesc();
        }
        return null;
    }

    public static List<Integer> getListByGroup(Integer businessGroup) {
        return Arrays.stream(BelongingBusinessTypeEnum.values()).filter(item -> item.getBusinessGroup().getType().equals(businessGroup)).map(BelongingBusinessTypeEnum::getType).collect(Collectors.toList());
    }
}
