package cn.com.duiba.quanyi.center.api.enums.settlement.receive;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/18 18:07
 */
@AllArgsConstructor
@Getter
public enum SettlementReceivedTypeEnum {
    NORMAL(1, "普通"),
    PREPAYMENT_REFUND(2, "预付款退款"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, SettlementReceivedTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementReceivedTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static SettlementReceivedTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
