package cn.com.duiba.quanyi.center.api.param.demand.task;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 批量更换供应商操作任务表
 * @author mybatis generator 
 * @date 2025-02-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ChangeSkuTaskSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17397750148464084L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 原sku_id
     */
    private Long oldSkuId;

    /**
     * 原spu_id
     */
    private Long oldSpuId;

    /**
     * 原供应商id
     */
    private Long oldSupplierId;

    /**
     * 新sku_id
     */
    private Long newSkuId;

    /**
     * 新spu_id
     */
    private Long newSpuId;

    /**
     * 新供应商id
     */
    private Long newSupplierId;

    /**
     * 操作人id
     */
    private Long createOperatorId;

    /**
     * 操作人姓名
     */
    private String createOperatorName;

    /**
     * 需求个数
     */
    private Integer demandCount;

    /**
     * 勾选需求个数
     */
    private Integer chooseDemandCount;

    /**
     * 活动个数
     */
    private Integer activityCount;

    /**
     * 勾选活动个数
     */
    private Integer chooseActivityCount;

    /**
     * 0-初始化 1-子任务创建成功  2-子任务部分执行成功 3-子任务执行成功
     * @see cn.com.duiba.quanyi.center.api.enums.demand.ChangeSkuTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 变更需求商品总数
     */
    private Integer demandGoodsTotalCount;

    /**
     * 变更活动奖品总数
     */
    private Integer activityPrizeTotalCount;

    /**
     * 变更活动奖品卡包总数
     */
    private Integer goodsPkgTotalCount;
}