package cn.com.duiba.quanyi.center.api.param.settlement.receive;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 回款
 * @author mybatis generator
 * @date 2024-12-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ReceivedPaymentSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17338978956686204L;
    /**
     * 打款主体ID集合
     */
    private List<Long> paymentSubjectIdList;

    /**
     * 打款主体ID
     */
    private Long paymentSubjectId;

    /**
     * 到款日期-开始时间
     */
    private Date receivedDateStart;

    /**
     * 到款日期-结束时间
     */
    private Date receivedDateEnd;

    /**
     * 商务ssoId
     */
    private Long commerceId;

    /**
     * 商务ssoId
     */
    private List<Long> commerceIdList;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedStatusEnum
     */
    private Integer receivedStatus;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedStatusEnum
     */
    private List<Integer> receivedStatusList;

    /**
     * 回款金额
     */
    private Long receivedAmount;

    /**
     * 回款单id
     */
    private String receivedNo;

    /**
     * 所属业务
     * @see cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum
     */
    private Integer belongingBusiness;

    /**
     * 回款单id集合
     */
    private List<Long> ids;

    /**
     * 回款备注
     */
    private String receivedRemark;

    /**
     * 所属业务
     * @see cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum
     */
    private List<Integer> belongingBusinessList;

    /**
     * 回款类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedTypeEnum
     */
    private Integer receivedType;
}
