package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityBlackWhiteListDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.cache.ActivityBlackWhiteListCacheDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityBlackWhiteListBatchDeleteParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityBlackWhiteListSearchParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityBlackWhiteListTimeRangeQueryParam;

/**
 * 活动黑白名单表
 * @author kjj mybatis generator
 * @date 2025-04-15
 */
@AdvancedFeignClient
public interface RemoteActivityBlackWhiteListService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动黑白名单集合
     */
    List<ActivityBlackWhiteListDto> selectPage(ActivityBlackWhiteListSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityBlackWhiteListSearchParam param);

    /**
     * 根据用户活动ID查询
     * @param userMark 用户唯一标记
     * @param activityId 活动ID
     * @return 活动黑白名单
     */
    List<ActivityBlackWhiteListCacheDto> selectByUserActIdCache(String userMark, Long activityId);

    /**
     * 根据用户活动ID查询(仅仅走redis，redis中没有返回null)
     * @param userMark 用户唯一标记
     * @param activityId 活动ID
     * @return 活动黑白名单
     */
    @Nullable
    List<ActivityBlackWhiteListCacheDto> selectByUserActIdOnlyCache(String userMark, Long activityId);

    /**
     * 根据用户活动ID批量查询
     * @param activityUserMarkMap key：活动ID，value：用户唯一标记
     * @return key：活动ID，value：活动黑白名单
     */
    Map<Long, List<ActivityBlackWhiteListCacheDto>> selectMapByUserActIdCache(Map<Long, String> activityUserMarkMap);

    /**
     * 根据用户活动ID批量查询(仅仅走redis，redis中没有返回null)
     * @param activityUserMarkMap key：活动ID，value：用户唯一标记
     * @return key：活动ID，value：活动黑白名单
     */
    Map<Long, List<ActivityBlackWhiteListCacheDto>> selectMapByUserActIdOnlyCache(Map<Long, String> activityUserMarkMap);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动黑白名单
     */
    ActivityBlackWhiteListDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动黑白名单
     * @return 执行结果
     * @throws BizException 业务异常
     */
    int insert(ActivityBlackWhiteListDto dto) throws BizException;

    /**
     * 更新
     * @param dto 活动黑白名单
     * @return 影响行数
     */
    int update(ActivityBlackWhiteListDto dto);

    /**
     * 删除
     *
     * @param id           主键
     * @param operatorType 操作人类型
     * @param operatorId   操作人id
     * @param operatorName 操作人名字
     * @return 执行结果
     * @throws BizException 业务异常
     */
    int delete(Long id, Integer operatorType, Long operatorId, String operatorName) throws BizException;

    /**
     * 批量新增
     * @param activityId 活动ID
     * @param list 活动黑白名单
     * @return 执行结果
     */
    int batchInsert(Long activityId, List<ActivityBlackWhiteListDto> list);

    /**
     * 根据用户唯一标识、活动ID和时间范围查询所有记录(时间有交集就查询出来)
     * @param param 时间范围查询参数
     * @return 活动黑白名单集合
     */
    List<ActivityBlackWhiteListDto> selectByUserActIdAndTimeRange(ActivityBlackWhiteListTimeRangeQueryParam param);

    /**
     * 批量软删除
     * @param param 批量删除参数
     * @return 执行结果
     */
    int batchDelete(ActivityBlackWhiteListBatchDeleteParam param) throws BizException;

    /**
     * 查询已添加人数
     * @param activityId 活动ID
     * @param operatorType 操作人类型
     * @param operatorId 操作人ID
     * @return 已添加人数
     */
    Long selectAddedNum(Long activityId, Integer operatorType, Long operatorId);

    /**
     * 修改导入次数
     * @param dto 活动黑白名单
     * @return 影响行数
     */
    int updateImportCount(ActivityBlackWhiteListDto dto);
}
