package cn.com.duiba.quanyi.center.api.remoteservice.demandorder;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demandorder.DemandOrderDto;
import cn.com.duiba.quanyi.center.api.param.demandorder.DemandOrderSearchParam;
import java.util.List;

/**
 * 需求单
 * @author kjj mybatis generator 
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteDemandOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 需求单集合
     */
    List<DemandOrderDto> selectPage(DemandOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求单
     */
    DemandOrderDto selectById(Long id);

    /**
     * 新增
     * @param dto 需求单
     * @return 执行结果
     */
    int insert(DemandOrderDto dto);

    /**
     * 更新
     * @param dto 需求单
     * @return 影响行数
     */
    int update(DemandOrderDto dto);

    /**
     * 批量导出需求单
     *
     * @param param 查询需求单参数
     * @param createOperatorId 创建人id
     * @param createOperatorName 创建人姓名
     * @return 导出结果
     */
    boolean batchExport(DemandOrderSearchParam param, Long createOperatorId, String createOperatorName);

    /**
     * 重试
     *
     * @param taskId 根据任务id重试
     * @return 重试结果
     */
    boolean retry(Long taskId);
}