package cn.com.duiba.quanyi.center.api.remoteservice.warn;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.warn.DingDingWarnCountDto;
import cn.com.duiba.quanyi.center.api.dto.warn.DingDingWarnRecordDto;
import cn.com.duiba.quanyi.center.api.param.warn.DingDingWarnRecordSearchParam;

import java.util.List;

/**
 * 钉钉工作通知告警记录表
 * @author kjj mybatis generator
 * @date 2025-06-04
 */
@AdvancedFeignClient
public interface RemoteDingDingWarnRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 钉钉工作通知告警记录
     */
    DingDingWarnRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 钉钉工作通知告警记录
     * @return 执行结果
     */
    int insert(DingDingWarnRecordDto dto);

    /**
     * 更新
     * @param dto 钉钉工作通知告警记录
     * @return 影响行数
     */
    int update(DingDingWarnRecordDto dto);

    /**
     * 钉钉告警列表
     * @param warnType 告警类型
     * @param createOperatorId 被告警人
     * @see cn.com.duiba.quanyi.center.api.enums.warn.DingDingWarnTypeEnum
     * @return 钉钉高警列表集合
     */
    List<DingDingWarnRecordDto> selectByTypeAndCreateOperatorId(Integer warnType,Long createOperatorId);

    /**
     * 钉钉告警已读
     * @param id 主键id
     * @return 结果
     */
    int dingWarnRead(Long id);

    /**
     * 钉钉告警数量
     * @param warnOperatorId 告警人
     * @return 钉钉告警数量
     */
    DingDingWarnCountDto getDingDingWarnCount(Long warnOperatorId);

    /**
     * 分页查询钉钉告警列表
     * @param param 查询参数
     * @return 钉钉告警列表集合
     */
    List<DingDingWarnRecordDto> selectPage(DingDingWarnRecordSearchParam param);

    /**
     * 查询钉钉告警记录总数
     * @param param 查询参数
     * @return 总记录数
     */
    long selectCount(DingDingWarnRecordSearchParam param);
}
