package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 发票回款超期状态枚举
 * @author xuzhigang
 * @date 2025/1/8
 */
@AllArgsConstructor
@Getter
public enum InvoiceReceivedOverdueStatusEnum {
    RECEIVED_NOT_OVERDUE(1, "已回款未超期"),
    RECEIVED_OVERDUE(2, "已回款已超期"),
    NOT_RECEIVED_NOT_OVERDUE(3, "未回款未超期"),
    NOT_RECEIVED_OVERDUE(4, "未回款已超期"),
    ;

    private static final Map<Integer, InvoiceReceivedOverdueStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InvoiceReceivedOverdueStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    private final Integer status;
    private final String desc;

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static InvoiceReceivedOverdueStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
