package cn.com.duiba.quanyi.center.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/4/15 18:35
 */
@AllArgsConstructor
@Getter
public enum UserExtCommonKeyEnum {
    USER_PHONE(1, "用户手机号"),
    CORE_CLIENT_NUMBER(2, "核心客户号"),
    BANK_CLIENT_NUMBER(3, "网银客户号"),
    WX_OPEN_ID(4, "用户微信openId"),
    WX_APP_ID(5, "用户微信appId"),
    ALI_OPEN_ID(6, "用户支付宝openId"),
    ALI_APP_ID(7, "用户支付宝appId"),
    ALI_PHONE(8, "用户支付宝手机号"),
    ALI_USER_ID(9, "用户支付宝用户ID"),
    ALI_LOGIN_ID(10, "用户支付宝账号"),
    BOC_SZ_SYSID(11, "深圳中行系统id"),
    ;

    private final Integer code;

    private final String name;

    private static final Map<Integer, UserExtCommonKeyEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(UserExtCommonKeyEnum::getCode, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param code 枚举值
     * @return 枚举
     */
    public static UserExtCommonKeyEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
