package cn.com.duiba.quanyi.center.api.param.api;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * API多选一供给标准下单参数
 * 
 * @author lizhi
 * @date 2023/12/4 20:29
 */
@Data
public class ApiMultiChoiceOneCreateOrderParam implements Serializable {

    private static final long serialVersionUID = -4402952009826854906L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 回调通知mq topic
     */
    private String notifyMqTopic;

    /**
     * 同步结果mq topic
     */
    private String syncMqTopic;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 内部业务参数，json格式
     */
    private ApiCreateOrderBizJsonParam bizJsonParam;

    /**
     * 订单类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiOrderTypeEnum
     */
    private Integer orderType;

}
