package cn.com.duiba.quanyi.center.api.remoteservice.insurance.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.verify.InsuranceVerifyIssueLogDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceVerifyIssueLogSearchParam;
import java.util.List;

/**
 * MQ审核异常表
 * @author kjj mybatis generator 
 * @date 2024-03-15
 */
@AdvancedFeignClient
public interface RemoteInsuranceVerifyIssueLogService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return MQ审核异常集合
     */
    List<InsuranceVerifyIssueLogDto> selectPage(InsuranceVerifyIssueLogSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceVerifyIssueLogSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return MQ审核异常
     */
    InsuranceVerifyIssueLogDto selectById(Long id);

    /**
     * 新增
     * @param dto MQ审核异常
     * @return 执行结果
     */
    int insert(InsuranceVerifyIssueLogDto dto);

    /**
     * 更新
     * @param dto MQ审核异常
     * @return 影响行数
     */
    int update(InsuranceVerifyIssueLogDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}