package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementContractDetailDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementContractDetailFillAmountParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementContractLockOrUnlockParam;

/**
 * 结算单合同明细
 * @author kjj mybatis generator
 * @date 2025-01-20
 */
@AdvancedFeignClient
public interface RemoteSettlementContractDetailService {

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 结算单合同明细
     */
    List<SettlementContractDetailDto> selectByIds(List<Long> ids);

    /**
     * 批量新增
     *
     * @param list 结算单合同明细
     * @return 执行结果
     */
    int batchInsert(List<SettlementContractDetailDto> list);

    /**
     * 根据结算单ID查询列表
     *
     * @param settlementId 结算单ID
     * @return 结算单合同明细集合
     */
    List<SettlementContractDetailDto> selectBySettlementId(Long settlementId);

    /**
     * 批量锁定或解锁合同明细
     * @param lockOrUnlockParamList 锁定或解锁参数集合
     * @return 执行结果
     */
    boolean batchLockOrUnlock(List<SettlementContractLockOrUnlockParam> lockOrUnlockParamList);

    /**
     * 批量回填开票金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillInvoicedAmount(List<SettlementContractDetailFillAmountParam> list);

    /**
     * 批量回填回款金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillReceivedAmount(List<SettlementContractDetailFillAmountParam> list);

}
