package cn.com.duiba.quanyi.center.api.remoteservice.workflow;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.workflow.WorkflowApprovalDetailDto;
import cn.com.duiba.quanyi.center.api.param.workflow.DemandWorkflowStartApprovalProcessParam;

/**
 * 需求审批流远程服务
 *
 * @author xuzhigang
 * @date 2025-07-07
 */
@AdvancedFeignClient
public interface RemoteDemandWorkflowService {

    /**
     * 发起需求审批流程
     *
     * @param param 审批参数
     * @return 审批流实例ID
     * @throws BizException 业务异常
     */
    Long startDemandApprovalProcess(DemandWorkflowStartApprovalProcessParam param) throws BizException;

    /**
     * 获取需求审批详情
     *
     * @param demandChangeRecordId 需求变更记录ID
     * @param refresh 是否刷新
     * @return 审批详情
     */
    WorkflowApprovalDetailDto getDemandApprovalDetail(Long demandChangeRecordId, boolean refresh);
}
