package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 活动员工信息表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityStaffDto implements Serializable {

    private static final long serialVersionUID = -7961983564257523363L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 员工手机号
     */
    private String staffPhone;
    /**
     * 上传任务id
     */
    private Long taskId;

    /**
     * 客户经理用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户角色，1-客户经理，2-管理员
     * @see cn.com.duiba.quanyi.center.api.enums.activity.UserRoleEnum
     */
    private Integer userRole;

    /**
     * 是否限制添加次数，0-不限制，1-限制
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer addLimitType;

    /**
     * 总添加次数
     */
    private Long totalAddNum;

    /**
     * 添加白名单的操作人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum
     */
    private Integer operatorType;

    /**
     * 添加人Id
     */
    private Long operatorId;

    /**
     * 添加人姓名
     */
    private String operatorName;

    /**
     * 添加时间
     */
    private Date addTime;

    /**
     * 删除白名单的操作人类型，1-内部sso用户，2-合作方员工
     * @see cn.com.duiba.quanyi.center.api.enums.activity.OperatorTypeEnum
     */
    private Integer deleteOperatorType;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;

    /**
     * 删除时间
     */
    private Date deleteTime;

    /**
     * 绑定用户时间
     */
    private Date bindTime;

    /**
     * 是否限制添加时间，0-不限制，1-限制
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer addTimeLimitType;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}