package cn.com.duiba.quanyi.center.api.dto.contract;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 合同消耗明细
 *
 * @author xuzhigang
 * @date 2025-06-05
 */
@Data
public class ContractConsumeDetailDto implements Serializable {

    private static final long serialVersionUID = 3847291650384729165L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 合同id tb_contract.id
     */
    private Long contractId;

    /**
     * 需求id tb_demand.id
     */
    private Long demandId;

    /**
     * 需求创建时间
     */
    private Date demandCreateDate;

    /**
     * 需求创建ssoId
     */
    private Long demandCreatorSsoId;

    /**
     * 消耗金额
     */
    private Long consumeAmount;

    /**
     * 是否超额 0-未超额 1-超额
     */
    private Integer hasOverAmount;

    /**
     * 超出金额
     */
    private Long overAmount;

    /**
     * 合同占用金额
     */
    private Long occupyContractAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
