package cn.com.duiba.quanyi.center.api.dto.settlement.task;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 任务与统计关系表
 * @author mybatis generator
 * @date 2024-11-30
 */
@Data
public class SettlementStatTaskRefDto implements Serializable {

    private static final long serialVersionUID = 17329512198873180L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 发票与结算单关联关系
     */
    private Long invoiceSettlementRefId;

    /**
     * 任务类型：1-开票，2-发票红冲，3-发票移除，4-回款认领，5-回款取消认领
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 统计库ID
     */
    private Long settlementOrderStatDayId;

    /**
     * 统计ID类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatIdTypeEnum
     */
    private Integer statIdType;

    /**
     * 填充上去的金额
     */
    private Long fillAmount;
}
