package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同占用金额变更类型枚举
 *
 * @author xuzhigang
 * @date 2025-01-20
 */
@Getter
@AllArgsConstructor
public enum ContractOccupyAmountChangeTypeEnum {

    /**
     * 添加需求
     */
    ADD_DEMAND(1, "添加需求"),

    /**
     * 添加需求商品
     */
    ADD_DEMAND_GOODS(2, "添加需求商品"),

    /**
     * 移除需求商品
     */
    REMOVE_DEMAND_GOODS(3, "移除需求商品"),

    /**
     * 变更需求关联合同
     */
    CHANGE_DEMAND_CONTRACT_REF(4, "变更需求关联合同"),

    /**
     * 更新需求商品消耗预算
     */
    UPDATE_DEMAND_GOODS_CONSUME_BUDGET(5, "更新需求商品消耗预算"),

    /**
     * 添加需求审批拒绝
     */
    ADD_DEMAND_APPROVAL_REFUSE(6, "添加需求审批拒绝"),

    /**
     * 添加需求商品审批拒绝
     */
    ADD_DEMAND_GOODS_APPROVAL_REFUSE_OR_FAIL(7, "添加需求商品审批拒绝或失败"),

    /**
     * 批量修改消耗预算审批拒绝
     */
    BATCH_UPDATE_CONSUME_BUDGET_APPROVAL_REFUSE_OR_FAIL(8, "批量修改消耗预算审批拒绝或失败"),

    /**
     * 需求合同金额退回
     */
    REFUND_CONTRACT_AMOUNT(9, "需求合同金额退回"),

    ;

    /**
     * 类型编码
     */
    private final Integer type;

    /**
     * 类型描述
     */
    private final String desc;

    /**
     * 根据类型获取枚举
     *
     * @param type 类型
     * @return 枚举
     */
    public static ContractOccupyAmountChangeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (ContractOccupyAmountChangeTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
