package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2024/3/4 14:36
 */
@Getter
@AllArgsConstructor
public enum InsuranceAdditionalAuditStatusEnum {
    NOT_AUDIT(0, "待审核"),
    PASS(1, "审核通过"),
    NO_PASS(2, "审核不通过"),
    ;

    public static InsuranceAdditionalAuditStatusEnum getByStatus(Integer status){
        for (InsuranceAdditionalAuditStatusEnum audit : InsuranceAdditionalAuditStatusEnum.values()){
            if (Objects.equals(audit.getStatus(), status)){
                return audit;
            }
        }
        return null;
    }
    
    private final Integer status;
    
    private final String desc;
}
