package cn.com.duiba.quanyi.center.api.enums.task;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 定时任务规则
 * 1-替换，2-新增，3-删除
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ScheduledTaskBizRuleEnum {

    DEFAULT(0, "默认规则"),
    REPLACE(1, "替换"),
    ADD(2, "新增"),
    DELETE(3, "删除"),
    ;


    /**
     * 规则类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    public static ScheduledTaskBizRuleEnum getByType(Integer type) {
        for (ScheduledTaskBizRuleEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
