package cn.com.duiba.quanyi.center.api.param.payment;

import lombok.Data;

import java.io.Serializable;

/**
 * 供应商预付款抵扣金额更新参数
 * @author xuzhigang
 * @date 2025-10-15 14:30
 */
@Data
public class SupplierPrepaymentDeductionUpdateParam implements Serializable {

    private static final long serialVersionUID = 1734567890123456789L;

    /**
     * 预付款ID
     */
    private Long id;

    /**
     * 增量抵扣金额
     */
    private Long incrementAmount;

    /**
     * 实际付款金额（用于乐观锁校验）
     */
    private Long actualPaymentAmount;

    /**
     * 预付款状态（如果需要更新状态，可为null）
     */
    private Integer prepaymentStatus;
}

