package cn.com.duiba.quanyi.center.api.remoteservice.contract;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractConsumeDetailDto;
import cn.com.duiba.quanyi.center.api.param.contract.ContractConsumeDetailPageQueryParam;

import java.util.List;

/**
 * 合同消耗明细
 *
 * @author xuzhigang
 * @date 2025-06-05
 */
@AdvancedFeignClient
public interface RemoteContractConsumeDetailService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 合同消耗明细
     */
    ContractConsumeDetailDto selectById(Long id);

    /**
     * 根据主键列表批量查询
     *
     * @param ids 主键列表
     * @return 合同消耗明细列表
     */
    List<ContractConsumeDetailDto> selectByIds(List<Long> ids);

    /**
     * 根据合同ID查询
     *
     * @param contractId 合同ID
     * @return 合同消耗明细列表
     */
    List<ContractConsumeDetailDto> selectByContractId(Long contractId);

    /**
     * 根据需求ID查询
     *
     * @param demandId 需求ID
     * @return 合同消耗明细列表
     */
    List<ContractConsumeDetailDto> selectByDemandId(Long demandId);

    /**
     * 根据合同ID和需求ID查询
     *
     * @param contractId 合同ID
     * @param demandId   需求ID
     * @return 合同消耗明细
     */
    ContractConsumeDetailDto selectByContractIdAndDemandId(Long contractId, Long demandId);

    /**
     * 新增
     *
     * @param dto 合同消耗明细
     * @return 主键ID
     */
    Long insert(ContractConsumeDetailDto dto);

    /**
     * 批量新增
     *
     * @param dtos 合同消耗明细列表
     * @return 执行结果
     */
    int batchInsert(List<ContractConsumeDetailDto> dtos);

    /**
     * 更新
     *
     * @param dto 合同消耗明细
     * @return 执行结果
     */
    int update(ContractConsumeDetailDto dto);

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 合同消耗明细列表
     */
    List<ContractConsumeDetailDto> selectPageByParam(ContractConsumeDetailPageQueryParam param);

    /**
     * 统计查询
     *
     * @param param 查询参数
     * @return 记录总数
     */
    Long countByParam(ContractConsumeDetailPageQueryParam param);

    /**
     * 同步占用合同金额
     * 根据需求合同关联表更新合同消耗明细表的占用金额
     *
     * @param demandId 需求ID
     * @return 更新的记录数
     */
    int syncOccupyContractAmount(Long demandId);

    /**
     * 根据合同ID和需求ID更新占用合同金额
     *
     * @param contractId 合同ID
     * @param demandId 需求ID
     * @param occupyContractAmount 占用合同金额
     * @return 更新的记录数
     */
    int updateOccupyContractAmount(Long contractId, Long demandId, Long occupyContractAmount);
}
