package cn.com.duiba.quanyi.center.api.remoteservice.insurance.auto;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.auto.InsuranceSplitAddMoneyRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.auto.InsuranceSplitAddMoneyRecordSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 保司拆分加款记录
 * @author kjj mybatis generator
 * @date 2025-07-17
 */
@AdvancedFeignClient
public interface RemoteInsuranceSplitAddMoneyRecordService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司拆分加款记录集合
     */
    List<InsuranceSplitAddMoneyRecordDto> selectPage(InsuranceSplitAddMoneyRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceSplitAddMoneyRecordSearchParam param);

    /**
     * 任务重试
     * @param id 主键
     * @return left：是否成功，right：失败原因
     */
    Pair<Boolean, String> retry(Long id);
}
