package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectLossRecordDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectLossRecordPageQueryParam;

import java.util.List;

/**
 * 项目资损记录 Remote
 *
 * @author zzy
 * @since 2025-08-28 16:20
 */
@AdvancedFeignClient
public interface RemoteProjectLossRecordService {

    /**
     * 新增项目资损记录。
     *
     * @param dto 资损记录
     * @return 新增记录主键ID
     */
    Long insert(ProjectLossRecordDto dto);

    /**
     * 更新项目资损记录。
     *
     * @param dto 资损记录
     * @return 受影响行数
     */
    Integer update(ProjectLossRecordDto dto);

    /**
     * 软删除项目资损记录。
     *
     * @param id 记录ID
     * @return 受影响行数
     */
    Integer softDelete(Long id);

    /**
     * 分页查询项目资损记录。
     *
     * @param param 分页与筛选参数
     * @return 记录列表
     */
    List<ProjectLossRecordDto> selectPage(ProjectLossRecordPageQueryParam param);

    /**
     * 统计项目资损记录数量。
     *
     * @param param 统计条件
     * @return 总条数
     */
    Long selectCount(ProjectLossRecordPageQueryParam param);

    /**
     * 查询资损记录详情。
     *
     * @param id 记录ID
     * @return 详情
     */
    ProjectLossRecordDto selectById(Long id);
}


