package cn.com.duiba.quanyi.center.api.remoteservice.qy.store;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.store.ActivityPrizeStoreExtDto;
import cn.com.duiba.quanyi.center.api.param.qy.store.ActivityPrizeStoreExtSearchParam;

/**
 * 活动门店额外信息表
 * @author kjj mybatis generator
 * @date 2025-07-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeStoreExtService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动门店额外信息集合
     */
    List<ActivityPrizeStoreExtDto> selectPage(ActivityPrizeStoreExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPrizeStoreExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动门店额外信息
     */
    ActivityPrizeStoreExtDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动门店额外信息
     * @return 执行结果
     */
    Long insert(ActivityPrizeStoreExtDto dto);

    /**
     * 更新
     * @param dto 活动门店额外信息
     * @return 影响行数
     */
    int update(ActivityPrizeStoreExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 按条件查询主键ID列表
     * @param param 查询条件
     * @return 主键ID列表
     */
    List<ActivityPrizeStoreExtDto> selectIdList(ActivityPrizeStoreExtSearchParam param);

    /**
     * 批量新增
     */
    int batchInsert(List<ActivityPrizeStoreExtDto> activityPrizeStoreExtDtos);
}
