package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.CcbSettlementOssRefDto;
import cn.com.duiba.quanyi.center.api.param.settlement.CcbSettlementOssRefSearchParam;
import java.util.List;

/**
 * 建行结算单上传OSS文件路径
 * @author kjj mybatis generator
 * @date 2025-10-16
 */
@AdvancedFeignClient
public interface RemoteCcbSettlementOssRefService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 建行结算单上传OSS文件路径集合
     */
    List<CcbSettlementOssRefDto> selectPage(CcbSettlementOssRefSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbSettlementOssRefSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 建行结算单上传OSS文件路径
     */
    CcbSettlementOssRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 建行结算单上传OSS文件路径
     * @return 执行结果
     */
    int insert(CcbSettlementOssRefDto dto);

    /**
     * 更新
     * @param dto 建行结算单上传OSS文件路径
     * @return 影响行数
     */
    int update(CcbSettlementOssRefDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据结算单ID查询，返回建行结算单上传OSS文件路径集合
     * @param settlementId 结算单ID
     * @return 建行结算单上传OSS文件路径集合
     */
    List<String> selectBySettlementId(Long settlementId);

    /**
     * 批量新增
     * @param list 建行结算单上传OSS文件路径集合
     * @return 执行结果
     */
    int batchInsert(List<CcbSettlementOssRefDto> list);
}
