package cn.com.duiba.quanyi.center.api.remoteservice.subject;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.subject.DuibaSubjectDto;
import cn.com.duiba.quanyi.center.api.dto.subject.DuibaSubjectEsDto;
import cn.com.duiba.quanyi.center.api.param.subject.DuibaSubjectEsSearchParam;

/**
 * 兑吧主体表
 * 
 * @author kjj mybatis generator
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteDuibaSubjectService {

    /**
     * 根据主键查询
     * 
     * @param id 主键
     * @return 兑吧主体
     */
    DuibaSubjectDto selectById(Long id);

    /**
     * 新增
     * 
     * @param dto 兑吧主体
     * @return 执行结果
     */
    int insert(DuibaSubjectDto dto);

    /**
     * 更新
     * 
     * @param dto 兑吧主体
     * @return 影响行数
     */
    int update(DuibaSubjectDto dto);

    /**
     * 根据主体名称查询
     * 
     * @param subjectName 主体名称
     * @return 兑吧主体
     */
    DuibaSubjectDto selectBySubjectName(String subjectName);

    /**
     * 根据主体简称查询
     * 
     * @param subjectAbbreviation 主体简称
     * @return 兑吧主体
     */
    DuibaSubjectDto selectBySubjectAbbreviation(String subjectAbbreviation);

    /**
     * 根据es查询
     * 
     * @param searchParam 查询条件
     * @return 兑吧主体集合
     */
    Pair<Long, List<DuibaSubjectEsDto>> search(DuibaSubjectEsSearchParam searchParam);

    /**
     * 根据主键id集合查询
     * 
     * @param ids 主键id集合
     * @return key: 主体id value: 主体名称
     */
    Map<Long, String> getSubjectNameMapByIds(List<Long> ids);

    /**
     * 根据主键id集合查询
     * 
     * @param ids 主键id集合
     * @return key: 主体id value: 主体简称
     */
    Map<Long, String> getSubjectAbbreviationMapByIds(List<Long> ids);

    /**
     * 查询所有兑吧主体 初始化es数据用，其他场景勿用。
     * 
     * @return 兑吧主体列表
     */
    List<DuibaSubjectDto> selectAll();
}