package cn.com.duiba.quanyi.center.api.dto.activity.common.detail.collection;

import cn.com.duiba.quanyi.center.api.dto.activity.ActivityDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.detail.ActivityCommonDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageActivityConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageInterfaceConfDto;
import cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageParticipateLimitConfDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2025/4/14 16:47
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class ActivityCommonCollectionPageDetailDto extends ActivityDto {

    private static final long serialVersionUID = -5330018227749160796L;

    /**
     * 皮肤ID
     */
    private String skinId;

    /**
     * 子活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonCollectionPageSubTypeEnum
     */
    private Integer subType;

    /**
     * 用户限制
     */
    private ActivityCommonUserLimitConfDto userLimit;

    /**
     * 领奖开放时间
     */
    private ActivityCommonTimeLimitConfDto timeLimit;

    /**
     * 参与活动限制
     */
    private List<ActivityCommonCollectionPageParticipateLimitConfDto> participateLimit;

    /**
     * 报名配置
     */
    private ActivityCommonSignUpConfDto signUpConf;

    /**
     * 公告配置
     */
    private ActivityCommonNoticeConfDto noticeConf;

    /**
     * 界面配置
     */
    private ActivityCommonCollectionPageInterfaceConfDto interfaceConf;

    /**
     * 活动配置
     */
    private List<ActivityCommonCollectionPageActivityConfDto> activityConf;

    /**
     * key：活动ID，value：活动配置
     */
    private Map<Long, ActivityCommonDetailDto> activityMap;
}
