package cn.com.duiba.quanyi.center.api.dto.project;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目资损记录 DTO
 *
 * @author zzy
 * @since 2025-08-28 16:20
 */
@Data
public class ProjectLossRecordDto implements Serializable {

    private static final long serialVersionUID = 8237491823741234567L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 项目ID
     */
    private Long projectId;
    /**
     * 创建人姓名
     */
    private String createOperatorName;
    /**
     * 创建人id
     */
    private Long createOperatorId;
    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String description;
    /**
     * 金额（单位：分）
     */
    private Long amount;
    /**
     * 附件链接
     */
    private String attachmentUrl;
    /**
     * 发生时间
     */
    private Date occurrenceTime;
    /**
     * 审批状态：审批状态：1-待提交，2-提交失败，3-审核中，4-已撤回，5-已打回，6-已通过，7-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;
    /**
     * 删除状态：0-未删除，1-已删除
     */
    private Integer isDeleted;
}


