package cn.com.duiba.quanyi.center.api.dto.settlement.stat;

import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloGoodsStockAmountDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算订单统计-日纬度
 * @author mybatis generator 
 * @date 2024-11-26
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SettlementOrderStatDaySimpleDto extends SettlementHoloGoodsStockAmountDto {
     
    private static final long serialVersionUID = 17325899993232412L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一标记，需求商品ID与批次号，以_分隔；垫资：XX_XX
     */
    private String uniqueMark;

    /**
     * 锁定状态：0-未锁定，1-已锁定
     */
    private Integer lockStatus;

    /**
     * 结算单ID-开票
     */
    private Long settlementId;

    /**
     * 应收金额-开票
     */
    private Long receivableAmount;

    /**
     * 容差金额-开票
     */
    private Long toleranceAmount;

    /**
     * 结算金额
     */
    private Long settlementAmount;
}