package cn.com.duiba.quanyi.center.api.param.bill;

import cn.com.duiba.quanyi.center.api.enums.bill.BillPushTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 账单表
 * @author mybatis generator 
 * @date 2024-02-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class BillSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1708914349693117L;

    /**
     * 账单业务类型 1-江西银商
     */
    private Integer bizType;

    /**
     * 账单拉取类型 1 - 增量  2 - 全量
     * @see BillPushTypeEnum
     */
    private Integer pushType;

    /**
     * 不同账单业务类型对应不同的业务id 需求id/活动id...
     */
    private Long bizId;

    /**
     * 商户账号
     */
    private String mchId;


    /**
     * 创建人id
     */
    private Long creatorId;
}