package cn.com.duiba.quanyi.center.api.param.order;

import lombok.Data;

import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author zzy
 * @create 2025/06/06 17:28
 **/
@Data
public class BatchFixGoodsOrderParam implements Serializable {
    private static final long serialVersionUID = -2464339409108962009L;
    /**
     * 待批量修复的订单号列表
     */
    @NotEmpty
    private List<String> goodsOrderNos;

    /**
     * 是否需要在修复完成后执行发放逻辑
     */
    private boolean needGrantAfterFix = true;

    /**
     * 修复模式：1.替换微信批次号 2.替换支付宝批次号 3.替换支付宝AppId
     */
    @NotNull
    private Integer fixMode;

    /**
     * 订单状态列表，必须是批量修复的订单状态，必须要提供
     */
    @Nullable
    private List<Integer> goodsOrderStatusList;

    /**
     * 奖品ID
     */
    @NotNull
    private Long prizeId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    @NotNull
    private Integer spuType;

    /**
     * 失败原因
     */
    @Nullable
    private String errorMsg;

    /**
     * 展示给前端的错误码
     */
    @Nullable
    private String failCode;
    /**
     * 旧批次ID
     */
    @Nullable
    private String oldCouponId;
    /**
     * 新批次ID
     */
    @Nullable
    private String newCouponId;

    /**
     * 旧支付宝AppId
     */
    @Nullable
    private String oldAlipayAppid;

    /**
     * 新支付宝AppId
     */
    @Nullable
    private String newAlipayAppid;

    /**
     * 修复模式枚举
     */
    public enum FixModeType {
        /**
         * 替换微信批次号
         */
        FIX_WX_BATCH_NO(1),
        /**
         * 替换支付宝批次号
         */
        FIX_ALIPAY_BATCH_NO(2),
        /**
         * 替换支付宝AppId
         */
        FIX_ALIPAY_APP_ID(3),

        /**
         * 替换支付宝批次号和AppId
         */
        FIX_ALIPAY_BATCH_NO_AND_APP_ID(4);

        private Integer type;

        FixModeType(Integer value) {
            this.type = value;
        }

        public Integer getType() {
            return type;
        }
    }
}
