package cn.com.duiba.quanyi.center.api.param.workflow;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotEmpty;

import lombok.Data;

/**
 * 活动审批流批量查询参数
 * @author xuzhigang
 * @date 2025-06-19
 */
@Data
public class ActivityWorkflowBatchQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 查询条件集合
     */
    @NotEmpty(message = "查询条件不能为空")
    private List<ActivityWorkflowQueryCondition> queryConditions;

    /**
     * 活动审批流查询条件
     */
    @Data
    public static class ActivityWorkflowQueryCondition implements Serializable {

        private static final long serialVersionUID = 1L;

        /**
         * 活动ID
         */
        private Long activityId;

        /**
         * 活动类型
         * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
         */
        private Integer activityType;

        /**
         * 审批流类型
         * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
         */
        private Integer workflowType;
    }
} 