package cn.com.duiba.quanyi.center.api.remoteservice.bill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bill.BillDto;
import cn.com.duiba.quanyi.center.api.param.bill.BillSearchParam;

import java.util.List;

/**
 * 账单表
 * @author kjj mybatis generator 
 * @date 2024-02-26
 */
@AdvancedFeignClient
public interface RemoteBillService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 账单集合
     */
    List<BillDto> selectPage(BillSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BillSearchParam param);

    /**
     * 根据业务id和业务类型查询账单
     *
     * @param bizId 业务id
     * @param bizType 业务类型
     * @param pushType 推送类型
     * @return 账单
     */
    BillDto selectByBizAndPushType(Long bizId, Integer bizType, Integer pushType);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 账单
     */
    BillDto selectById(Long id);

    /**
     * 新增
     * @param dto 账单
     * @return 执行结果
     */
    int insert(BillDto dto);

    /**
     * 更新
     * @param dto 账单
     * @return 影响行数
     */
    int update(BillDto dto);

    /**
     * 批量更新创建人id
     *
     * @param oldCreatorId   原创建人id
     * @param newCreatorId   新的创建人id
     * @param newCreatorName 新的创建人姓名
     * @return 更新结果
     */
    int batchChangeCreatorId(Long oldCreatorId, Long newCreatorId, String newCreatorName);

    /**
     * 更新状态
     *
     * @param id 主键id
     * @param newStatus 新状态
     * @param oldStatus 老状态
     * @return 更新结果
     */
    int updateStatus(Long id, Integer newStatus, Integer oldStatus);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}