package cn.com.duiba.quanyi.center.api.remoteservice.insurance.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyFundDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyFundDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceCompanyFundSearchParam;
import java.util.List;

/**
 * 公司资金表
 * @author kjj mybatis generator 
 * @date 2024-07-17
 */
@AdvancedFeignClient
public interface RemoteInsuranceCompanyFundService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 公司资金集合
     */
    List<InsuranceCompanyFundDto> selectPage(InsuranceCompanyFundSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceCompanyFundSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 公司资金
     */
    InsuranceCompanyFundDto selectById(Long id);

    /**
     * 新增
     * @param dto 公司资金
     * @return 执行结果
     */
    int insert(InsuranceCompanyFundDto dto);

    /**
     * 更新
     * @param dto 公司资金
     * @return 影响行数
     */
    int update(InsuranceCompanyFundDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


    /**
     * 根据公司ID查询
     * @param companyId
     * @return 保司公司资金
     */
    InsuranceCompanyFundDto selectByCompanyId(Long companyId);


    /**
     * 根据公司ID列表，查询统计数据
     * @param companyIds
     * @return
     */
    List<InsuranceCompanyFundDto> selectByCompanyIds(List<Long> companyIds);


    /**
     * 变更资金
     * @param companyId 公司ID
     * @param changeType 变更类型，1-支出, 2-收入
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundChangeTypeEnum
     * @param changeAmount 变更金额，单位分
     * @param operatorPhone 操作人
     * @return
     */
    boolean change(Long companyId, Integer changeType, Long changeAmount, String operatorPhone);
}