package cn.com.duiba.quanyi.center.api.remoteservice.mall.address;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.address.MallUserAddressDto;

import java.util.List;

/**
 * 商城用户收货地址
 * @author kjj mybatis generator 
 * @date 2024-05-24
 */
@AdvancedFeignClient
public interface RemoteMallUserAddressService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城用户收货地址
     */
    MallUserAddressDto selectById(Long id);

    /**
     * 查询用户默认地址
     *
     * @param userId 用户ID
     * @return 商城用户收货地址
     */
    MallUserAddressDto selectUserDefault(Long userId);

    /**
     * 查询用户收货地址列表
     *
     * @param userId 用户ID
     * @return 商城用户收货地址集合
     */
    List<MallUserAddressDto> selectUserAddress(Long userId);

    /**
     * 查询用户未删除收货地址数量
     *
     * @param userId 用户ID
     * @return 符合条件的记录数
     */
    long selectUserAddressCount(Long userId);

    /**
     * 新增
     * @param dto 商城用户收货地址
     * @return 主键
     */
    Long save(MallUserAddressDto dto);

    /**
     * 更新
     * @param dto 商城用户收货地址
     * @return 影响行数
     */
    int update(MallUserAddressDto dto);

    /**
     * 设置默认地址
     *
     * @param userId 用户ID
     * @param id 主键
     * @return 是否成功
     */
    boolean updateDefault(Long userId, Long id);

    /**
     * 软删
     *
     * @param userId 用户ID
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long userId, Long id);
}