package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.DemandGoodsConsumeStatDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.DemandGoodsConsumeStatSearchParam;

/**
 * 需求商品消耗统计远程服务接口
 *
 * @author xuzhigang
 * @date 2025-6-3
 */
@AdvancedFeignClient
public interface RemoteDemandGoodsConsumeStatService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 需求商品消耗统计集合
     */
    List<DemandGoodsConsumeStatDto> selectPage(DemandGoodsConsumeStatSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandGoodsConsumeStatSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 需求商品消耗统计信息
     */
    DemandGoodsConsumeStatDto selectById(Long id);

    /**
     * 根据统计维度ID和类型查询
     *
     * @param statId   统计维度ID
     * @param statType 统计维度类型
     * @return 需求商品消耗统计信息
     */
    DemandGoodsConsumeStatDto selectByStatIdAndType(String statId, Integer statType);

    /**
     * 根据多个统计维度ID和单个类型查询
     *
     * @param statIds  统计维度ID列表
     * @param statType 统计维度类型
     * @return 需求商品消耗统计信息列表
     */
    List<DemandGoodsConsumeStatDto> selectByStatIdsAndType(List<String> statIds, Integer statType);

    /**
     * 根据统计维度类型查询
     *
     * @param statType 统计维度类型
     * @return 需求商品消耗统计信息列表
     */
    List<DemandGoodsConsumeStatDto> selectByStatType(Integer statType);

    /**
     * 根据统计维度ID查询
     *
     * @param statId 统计维度ID
     * @return 需求商品消耗统计信息列表
     */
    List<DemandGoodsConsumeStatDto> selectByStatId(String statId);

    /**
     * 新增
     *
     * @param dto 需求商品消耗统计信息
     * @return 执行结果
     */
    int insert(DemandGoodsConsumeStatDto dto);

    /**
     * 批量新增
     *
     * @param dtoList 需求商品消耗统计信息列表
     * @return 执行结果
     */
    int batchInsert(List<DemandGoodsConsumeStatDto> dtoList);

    /**
     * 更新
     *
     * @param dto 需求商品消耗统计信息
     * @return 执行结果
     */
    int update(DemandGoodsConsumeStatDto dto);

    /**
     * 更新消耗金额（增量）
     *
     * @param statId          统计维度ID
     * @param statType        统计维度类型
     * @param incrementAmount 增量金额
     * @return 执行结果
     */
    int updateConsumeAmountIncrement(String statId, Integer statType, Long incrementAmount);

    /**
     * 插入或更新（存在则更新消耗金额，不存在则插入）
     *
     * @param dto 需求商品消耗统计信息
     * @return 执行结果
     */
    int insertOrUpdate(DemandGoodsConsumeStatDto dto);

    /**
     * 批量插入或更新（存在则更新消耗金额，不存在则插入）
     *
     * @param dtoList 需求商品消耗统计信息列表
     * @return 执行结果
     */
    int batchInsertOrUpdate(List<DemandGoodsConsumeStatDto> dtoList);
} 