/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.ccb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum BankTypeEnum {
    POSTAL_SAVINGS_CARD("01", "\u50a8\u84c4\u5361"),
    CREDIT_CARD("02", "\u4fe1\u7528\u5361"),
    DEBIT_OR_CREDIT("03", "\u50a8\u84c4\u5361\u4fe1\u7528\u5361\u901a\u7528");

    private final String bankType;
    private final String desc;
    private static final Map<String, BankTypeEnum> ENUM_MAP;

    private BankTypeEnum(String bankType, String desc) {
        this.bankType = bankType;
        this.desc = desc;
    }

    public static BankTypeEnum getByType(String bankType) {
        if (StringUtils.isBlank((CharSequence)bankType)) {
            return null;
        }
        return ENUM_MAP.get(bankType);
    }

    public String getBankType() {
        return this.bankType;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BankTypeEnum.values()).collect(Collectors.toMap(BankTypeEnum::getBankType, Function.identity(), (v1, v2) -> v2)));
    }
}

