package cn.com.duiba.quanyi.center.api.dto.goods.ext;

import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品库下单支付宝立减金扩展表
 * @author kjj mybatis generator 
 * @date 2023-09-23
 */
@Data
public class GoodsOrderAlipayCouponDto implements Serializable {

    private static final long serialVersionUID = -1166657478933183773L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private Long demandGoodsId;

    /**
     * 支付宝立减金主键, tb_alipay_activity.id
     */
    private Long alipayCouponId;

    /**
     * 支付宝活动批次号
     */
    private String actId;

    /**
     * 支付宝应用id
     */
    private String appId;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 收款用户userId
     */
    private String userId;

    /**
     * 邮箱号
     */
    private String loginId;

    /**
     * 手机号
     */
    private String phoneId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}