package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 结算单锁定或解锁任务表
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
public class InvoiceApplyTaskDto implements Serializable {
     
    private static final long serialVersionUID = 17332067335672495L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 业务ID，1时为项目ID，2时为供应商ID
     */
    private Long projectId;

    /**
     * 开票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 锁定版本
     */
    private Integer lockVersion;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 任务类型：1-锁定，2-解锁
     * @see cn.com.duiba.quanyi.center.api.enums.invoice.InvoiceApplyTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 任务状态
     * @see cn.com.duiba.quanyi.center.api.enums.invoice.InvoiceApplyTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 失败原因
     */
    private String errMsg;

    /**
     * 业务类型，1-开票申请锁定，2-供应商结算单锁定
     */
    private Integer bizType;
}