package cn.com.duiba.quanyi.center.api.dto.project;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目对接人
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
public class ProjectContactsDto implements Serializable {
     
    private static final long serialVersionUID = 17294988941222784L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 项目主键, tb_project.id
     */
    private Long projectId;

    /**
     * 姓名
     */
    private String userName;

    /**
     * 部门
     */
    private String department;

    /**
     * 职务
     */
    private String jobTitle;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 微信
     */
    private String userWx;

    /**
     * 邮箱
     */
    private String userEmail;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 退款结算天数
     */
    private Integer settlementDeadlineDays;

    /**
     * 退款结算类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.SettlementDeadlineTypeEnum
     */
    private Integer settlementDeadlineType;

    /**
     * 用户地区
     */
    private String userArea;

    /**
     * 用户地区编码
     */
    private String userAreaCode;
}