package cn.com.duiba.quanyi.center.api.dto.settlement.stat;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 结算方案流水记录表
 * @author mybatis generator 
 * @date 2024-11-28
 */
@Data
public class SettlementOrderPreviewRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17327624055291807L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 统计表ID
     */
    private Long statId;

    /**
     * 任务ID
     */
    private String taskId;

    /**
     * 日期
     */
    private Date statDate;

    /**
     * 项目商品ID
     */
    private Long projectGoodsId;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 商品明细唯一标记
     */
    private String uniqueMark;

    /**
     * 批次号，默认-
     */
    private String stockId;

    /**
     * 活动ID，默认-
     */
    private String thirdActivityId;

    /**
     * 活动名称，默认-
     */
    private String activityName;

    /**
     * 钱包号，默认-
     */
    private String walletNum;

    /**
     * 采购商品类型
     */
    private Integer purchaseSpuType;

    /**
     * 技术商品类型
     */
    private Integer spuType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 面额
     */
    private Long couponAmount;

    /**
     * 最小结算费率
     */
    private String minSettlementRate;

    /**
     * 最大结算费率
     */
    private String maxSettlementRate;

    /**
     * 最小结算价
     */
    private Long minSettlementPrice;

    /**
     * 最大结算价
     */
    private Long maxSettlementPrice;

    /**
     * 结算方式
     *
     * @see cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum
     */
    private Integer settlementMethod;

    /**
     * 消耗数
     */
    private Long consumedNum;

    /**
     * 优惠金额
     */
    private Long discountAmount;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 商品规格
     */
    private String skuConf;


    /**
     * 付款附件
     */
    private String paymentAttachment;

    /**
     * 天粒度与汇总粒度容差金额
     */
    private Long sumToleranceAmount;
}