package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 兑吧账号主体
 * 1.兑吧 2.兑啊 3.客吉吉 4.安徽兑吧 5.其他
 */
@Getter
@AllArgsConstructor
public enum DuibaAccountSubjectEnum {

    DUI_BA(1, "兑吧"),
    DUI_A(2, "兑啊"),
    KJJ(3, "客吉吉"),
    AN_HUI_DUI_BA(4, "安徽兑吧"),
    OTHER(5, "其他"),
    ;

    private final Integer code;
    private final String desc;

    private static final Map<String, DuibaAccountSubjectEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(DuibaAccountSubjectEnum::getDesc, Function.identity(), (v1, v2) -> v2)));

    public static String getDesc(Integer code) {
        for (DuibaAccountSubjectEnum subjectEnum : DuibaAccountSubjectEnum.values()) {
            if (subjectEnum.getCode().equals(code)) {
                return subjectEnum.getDesc();
            }
        }
        return null;
    }

    /**
     * 根据描述获取枚举
     * @param desc 描述
     * @return 枚举
     */
    public static Integer getByDesc(String desc) {
        if (desc == null) {
            return null;
        }
        return ENUM_MAP.getOrDefault(desc, OTHER).code;
    }
}
